//------------------------------------------------------------------------------
// Tumar CSP
// Copyright (c) 2011 Scientific Lab. Gamma Technologies. All rights reserved.
// SDK
// Create TSP Request
//------------------------------------------------------------------------------
#include "ex_util.h"
//------------------------------------------------------------------------------
#define TSP_REQ_FILE "tsp_req.bin"
#define TSP_POLICY   "1.2.3"
//------------------------------------------------------------------------------
char *Data_for_sign=(char*)"1234567890ABCD";
//------------------------------------------------------------------------------
//         
// :
// 1.  TSP     
//------------------------------------------------------------------------------
int main(void)
{
 int code;
 HCRYPTPROV hProv=0;
 HCRYPTHASH hHash;
 DWORD dw,len;
 unsigned char WBuf[256];

 //  
 code=LoadTumarCSP((char*)CSP_LIB); if (code) {printf("Load CSP error: %d\n",code); return 1;}
 //
 //   CSP
 if (!CPAcquireContext(&hProv,(char*)CSP_PROF,0,NULL)) {
   printf("CPAcquireContext Error: %0X\n",GetLastErrorCSP(0));
   return 1;
 }
 //  -
 if (!CPCreateHash(hProv,CALG_TGR3411,0,0,&hHash)) {
   printf("CPCreateHash Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 if (!CPHashData(hProv,hHash,(BYTE*)Data_for_sign,strlen(Data_for_sign),0)) {
   printf("CPHashData Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //    TSP
 if (!CPSetHashParam(hProv,hHash,HP_TIME_STAMP_OID,(BYTE*)TSP_POLICY,0)) {
   printf("CPSetHashParam HP_TIME_STAMP_OID Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //    TSP-   :
 dw=1;
 if (!CPSetHashParam(hProv,hHash,HP_TIME_STAMP_CRT,(BYTE*)&dw,0)) {
   printf("CPSetHashParam HP_TIME_STAMP_CRT Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 len=sizeof(WBuf);
 if (!CPGetHashParam(hProv,hHash,HP_TIME_STAMP_REQ,WBuf,&len,0)) {
   printf("CPGetHashParam HP_TIME_STAMP_REQ Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 writeFile(TSP_REQ_FILE,WBuf,len);
 //
 CPDestroyHash(hProv,hHash);
 //   CSP
 CPReleaseContext(hProv,0);
 printf("OK\n");
 return 0;
}
//------------------------------------------------------------------------------
